import numpy as np
from math import *
import matplotlib
import matplotlib.pyplot as plt
import matplotlib.gridspec as gridspec
import sys, random, time
from mpl_toolkits.axes_grid1.inset_locator import zoomed_inset_axes
from mpl_toolkits.axes_grid1.inset_locator import mark_inset
from mpl_toolkits.axes_grid1.inset_locator import inset_axes

FPR_mean=np.array(np.loadtxt("centralized_learner_false_positive_mean_file.txt",dtype=float))
FPR_mean1=np.array(np.loadtxt("learner1_false_positive_mean_file.txt",dtype=float))
FPR_mean2=np.array(np.loadtxt("learner2_false_positive_mean_file.txt",dtype=float))
FPR_sd=np.array(np.loadtxt("centralized_learner_false_positive_sd_file.txt",dtype=float))
FPR_sd1=np.array(np.loadtxt("learner1_false_positive_sd_file.txt",dtype=float))
FPR_sd2=np.array(np.loadtxt("learner2_false_positive_sd_file.txt",dtype=float))

FNR_mean=np.array(np.loadtxt("centralized_learner_false_negative_mean_file.txt",dtype=float))
FNR_mean1=np.array(np.loadtxt("learner1_false_negative_mean_file.txt",dtype=float))
FNR_mean2=np.array(np.loadtxt("learner2_false_negative_mean_file.txt",dtype=float))
FNR_sd=np.array(np.loadtxt("centralized_learner_false_negative_sd_file.txt",dtype=float))
FNR_sd1=np.array(np.loadtxt("learner1_false_negative_sd_file.txt",dtype=float))
FNR_sd2=np.array(np.loadtxt("learner2_false_negative_sd_file.txt",dtype=float))

CVR_mean=np.array(np.loadtxt("centralized_learner_constraint_violation_mean_file.txt",dtype=float))
CVR_mean1=np.array(np.loadtxt("learner1_constraint_violation_mean_file.txt",dtype=float))
CVR_mean2=np.array(np.loadtxt("learner2_constraint_violation_mean_file.txt",dtype=float))
CVR_sd=np.array(np.loadtxt("centralized_learner_constraint_violation_sd_file.txt",dtype=float))
CVR_sd1=np.array(np.loadtxt("learner1_constraint_violation_sd_file.txt",dtype=float))
CVR_sd2=np.array(np.loadtxt("learner2_constraint_violation_sd_file.txt",dtype=float))

SR_mean=np.array(np.loadtxt("centralized_learner_success_mean_file.txt",dtype=float))
SR_mean1=np.array(np.loadtxt("learner1_success_mean_file.txt",dtype=float))
SR_mean2=np.array(np.loadtxt("learner2_success_mean_file.txt",dtype=float))
SR_sd=np.array(np.loadtxt("centralized_learner_success_sd_file.txt",dtype=float))
SR_sd1=np.array(np.loadtxt("learner1_success_sd_file.txt",dtype=float))
SR_sd2=np.array(np.loadtxt("learner2_success_sd_file.txt",dtype=float))

plt.rcParams.update({'font.size': 14})
axis=np.arange(0,20)

fig, ax = plt.subplots()
ax.plot(axis,FPR_mean,'-')
ax.fill_between(axis,FPR_mean-FPR_sd,FPR_mean+FPR_sd,alpha=0.2)
ax.plot(axis,FPR_mean1,'--')
ax.fill_between(axis,FPR_mean1-FPR_sd1,FPR_mean1+FPR_sd1,alpha=0.2)
ax.plot(axis,FPR_mean2,'-.')
ax.fill_between(axis,FPR_mean2-FPR_sd2,FPR_mean2+FPR_sd2,alpha=0.2)

plt.xticks(np.arange(2,20,42))
#plt.title('(c) Cumulative Rewards')
plt.xlabel('Demonstrations')
#plt.legend(loc=4)
#plt.savefig('cumulative_reward.pdf') 
plt.show()
